<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

    

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="SMC | ">
    <meta name="author" content="Shajedul Hasan Arman | armanhassan504@gmail.com | https://github.com/sh-arman | https://www.linkedin.com/in/armanhassan504">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/livecheck.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('front/css/all.css')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>SureX NodeTech</title>


</head>


<body>
     <div class="hero" id="hero">
        <img class="hero-img" src="<?php echo e(asset('front/images/topvector_1.svg')); ?>" alt="Background_image">
        <div class="hero-items">
            <div id="logos">
                <div>
                    <img class="logo-1 mb-4" src="<?php echo e(asset('front/images/sureX_white.png')); ?>">
                </div>
                    <?php if(Session::has('locale')): ?>
                    <?php if(Session::get('locale') == 'bn'): ?>
                        <a class="btnlng" id="btnlang" href="<?php echo e(route('locale.setting', 'en')); ?>" role="button">English</a>
                    <?php elseif(Session::get('locale') == 'en'): ?>
                        <a class="btnlng" id="btnlang" style="font-family: 'Hind Siliguri', sans-serif;" href="<?php echo e(route('locale.setting', 'bn')); ?>" role="button">বাংলা</a>
                    <?php endif; ?>
                    <?php else: ?>
                        <a class="btnlng" id="btnlang" href="<?php echo e(route('locale.setting', 'en')); ?>" role="button">English</a>
                    <?php endif; ?>
            </div>

            <div id="verfiedIcon" style="display: none"> <img class="mark" src="<?php echo e(asset('front/images/tick.svg')); ?>"></div>
            <div id="warningIcon" style="display: none"> <img class="mark"src="<?php echo e(asset('front/images/warning.svg')); ?>"> </div>
            <div id="wrongIcon" style="display: none"> <img class="mark" src="<?php echo e(asset('front/images/cross.svg')); ?>"></div>
        </div>
    </div>
    <div class="content" id="content">
        <div class="container">
            <?php echo $__env->yieldContent('content'); ?>
        </div>



        <?php echo $__env->make('livecheck.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <?php echo $__env->yieldContent('js'); ?>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\laravel\Aristhopharma_Surex\resources\views/livecheck/master.blade.php ENDPATH**/ ?>