
<?php $__env->startSection('title', 'Order Code | SureX Admin Panel'); ?>
<?php $__env->startSection('content'); ?>

    <form action="<?php echo e(route('order_store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="card">
            <h5 class="card-header">Order Code <b class="text-primary float-end"> Available Code's : &nbsp;
                    <?php echo e(number_format($codes)); ?> </b>
            </h5>
            <div class="row px-4">

                <div class="col-md-4">
                    <select name="template_id" class="form-select form-select-lg " id="exampleFormControlSelect1"
                        aria-label="Default select example" required>
                        <option selected>Select template</option>
                        <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($template->status == 'active'): ?>
                                <option value="<?php echo e($template->id); ?>"> <?php echo e($template->manufacture); ?> <?php echo e($template->product); ?>

                                    <?php echo e($template->detail); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                

                <div class="col-md-4">
                    <div class="form-floating">
                        <input name="manufacture_date" type="text" id="mfg_date"
                            class="form-control <?php $__errorArgs = ['manufacture_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>  datepicker"
                            aria-describedby="floatingInputHelp" required autocomplete="off" />
                        <label for="floatingInput">Manufacture Date<p class="text-danger ">*</p></label>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="form-floating">
                        <input name="expiry_date" type="text" id="expiry_date"
                            class="form-control <?php $__errorArgs = ['expiry_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>  datepicker"
                            aria-describedby="floatingInputHelp" required autocomplete="off" />
                        <label for="floatingInput">Expiry Date<p class="text-danger ">*</p></label>
                    </div>
                </div>



                <div class="col-md-4 py-2">
                    <div class="input-group mb-3">
                        <span class="input-group-text">Quanity <p class="text-danger ">*</p></span>
                        <input name="quantity" type="number" class="form-control <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            placeholder="10000">
                    </div>
                </div>


                

                <div class="col-md-8 py-2">
                    <div class="input-group">
                        <span class="input-group-text form-control <?php $__errorArgs = ['batch_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            required>Batch Number <p class="text-danger ">*</p></span>
                        <input name="batch_number_first" type="text" placeholder="Front" class="form-control">
                        <input name="batch_number_middle" type="text" placeholder="Middle" class="form-control">
                        <input name="batch_number_last" type="text" placeholder="Back" class="form-control">
                    </div>
                </div>


                <div class="col-md-6 py-2">
                    <div class="input-group mb-3">
                        <span class="input-group-text">Datapack Name <p class="text-danger ">*</p></span>
                        <input name="datapack_name" type="text"
                            class="form-control <?php $__errorArgs = ['datapack_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    </div>
                </div>


                <div class="col-md-12 pb-4 pt-2">
                    <!-- Button trigger modal -->
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#orderConfirm">
                        <i class='bx bxs-zap'></i> &nbsp; Generate Code
                    </button>
                </div>
                
                <p class="text-danger float-end">* Code generation max limit 200000 ( 2 lac ) per batch.</p>
                

            </div>
        </div>


        <!-- Vertically Centered Modal -->
        <div class="col-lg-4 col-md-6">
            <div class="modal fade" id="orderConfirm" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="h-100">
                            <img class="img-fluid d-flex mx-auto" src="<?php echo e(asset('admin/assets/img/alert.gif')); ?>"
                                alt="Card image cap" style="width: 10rem;" />
                            <div class="card-body">
                                <h4 class="card-title text-center">Please check if all information are correct. <br>
                                    If not, you can go back and change it.
                                </h4>
                                <h4 class="card-text text-center">
                                    <b>Your message will look like: </b>
                                    <p class="text-primary"> ABC ABCDXYZ </p>
                                </h4>
                            </div>
                        </div>
                        <div class="modal-footer d-flex justify-content-center">
                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Back</button>
                            <button type="submit" class="btn btn-primary">Confirm</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </form>



    
    <div class="row mt-4">
        <div class="col">
            <div class="card p-4">
                <table id="example" class="table dt-responsive nowrap" style="width:100%">
                    <thead>
                        <tr>
                            <th class="col-0">Sl</th>
                            
                            <th>Batch</th>
                            <th>Quantity</th>
                            <th>Status</th>
                            
                            <th>Code</th>
                            <th>Batch Code</th>
                            
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->index + 1); ?></td>
                                
                                <td><?php echo e($order->batch_number); ?></td>
                                <td><?php echo e($order->quantity); ?></td>
                                <td>
                                    <?php if($order->status == 'running'): ?>
                                        <span class="badge bg-label-danger me-1"><?php echo e(ucfirst($order->status)); ?></span>
                                    <?php elseif($order->status == 'pending'): ?>
                                        <span class="badge bg-label-warning me-1"><?php echo e(ucfirst($order->status)); ?></span>
                                    <?php elseif($order->status == 'finished'): ?>
                                        <span class="badge bg-label-info me-1"><?php echo e(ucfirst($order->status)); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($order->status == 'finished'): ?>
                                        <a class="btn btn-sm btn-primary" href="<?php echo e(asset('Codes/' . $order->file)); ?>"
                                            download="<?php echo e($order->file); ?>">
                                            
                                            <i class='bx bx-download'></i> &nbsp; CSV
                                        </a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a class="btn btn-sm btn-primary"
                                        href="<?php echo e(asset('Codes/' . $order->batch_file )); ?>"
                                        download="<?php echo e($order->batch_file); ?>">
                                        <i class='btn btn-sm btn-primary bx bx-download'></i> &nbsp; CSV

                                    </a>

                                </td>
                                
                                
                                
                                <td><?php echo e(date_format($order->created_at, 'd/m/y - g:i A')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
    <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
    <script>
        $('.datepicker').datepicker({
            format: 'yyyy-mm',
            autoclose: true,
            startView: "months",
            minViewMode: "months",
            viewMode: "months",
            changeMonth: true,
            changeYear: true
        });

        $('#mfg_date').datepicker().on("change", function() {
            var d = $('#mfg_date').datepicker('getDate');
            d.setFullYear(d.getFullYear(), d.getMonth() + 24);
            $('#expiry_date').datepicker('setDate', d);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\laravel\Aristhopharma_Surex\resources\views/admin/order.blade.php ENDPATH**/ ?>