<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Codes</title>
    {{-- for datatable bootstrap 5 --}}
    <link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.3.0/css/responsive.bootstrap5.min.css">
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('admin/assets/vendor/css/core.css') }}" />
    <link rel="stylesheet" href="{{ asset('admin/assets/vendor/css/theme-default.css') }}" />
    <link rel="stylesheet" href="{{ asset('admin/assets/css/demo.css') }}" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('admin/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <style>
    .loader {
    border: 16px solid #f3f3f3; /* Light grey */
    border-top: 16px solid #3498db; /* Blue */
    border-radius: 50%;
    width: 120px;
    height: 120px;
    animation: spin 2s linear infinite;
    }
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    .hide-loader{
    display:none;
    }
    </style>


</head>
<body class="p-3">
    {{-- <h1>Title</h1> --}}
    {{-- @dd($qrcodes); --}}
    <div>
        <a href="javascript:window.print()" class=" btn btn-primary waves-effect waves-light d-print-none mb-4 ">
            <i class="fa fa-print"></i>Print
        </a>
    </div>
    @foreach ($qrcodes as $qrcode)
    <div class="mb-3">
        {!! $qrcode !!}
        {{ $codes[$loop->iteration-1] }}
    </div>
    @endforeach
    {{-- @foreach ($qrcodes as $qrcode) --}}
        {{-- {!! $qrcode !!} --}}
            {{-- @foreach ($codes as $code)
            <div class="mb-3">
                {{ $code }}
            </div>
            @endforeach --}}
    {{-- @endforeach --}}

    <div id="qr"></div>
    {{-- <div class="loader" id="loader"></div> --}}
    <script>
        var offset = {{ count($qrcodes) }}; // Number of QR codes to load per request
        var chunk = 1000; // Number of QR codes to load per request
        var total = 10000;

        function loadMore(page) {
            $.ajax({
                url: "{{ route('qrcodes.load-more') }}",
                method: 'GET',
                data: {
                    offset: offset,
                    chunk: chunk,
                    total: total,
                    page: page
                },
                success: function(response) {
                    // var qrcodes = response.qrcodes;
                    var qr = $('#qr').append(response);
                    console.log("",page);
                    // window.alert(page + 1);
                    loadMore(page + 1); // Recursive call to load more data
                    // if (qrcodes.length > 0) {
                    //     qrcodes.forEach(function(qrcode) {
                    //         container.append('<img src="data:image/png;base64,' + qrcode + '" alt="QR Code">');
                    //     });

                    //     offset += qrcodes.length;
                    //                        }
                    // $('#loader').addClass("hide-loader");
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }

        // Initial call to load more data
        loadMore(1);
    </script>

</body>

</html>
