@extends('admin.layouts.layout')

@section('title','Dashboard | SureX Admin Panel')

@section('content')

    <div class="row mb-4">
            <div class="col-lg-6">
                    <div class="d-flex align-items-end">
                        <div class="card shadow-lg bg-white rounded">
                            <div class="input-group">
                                <span class="input-group-text">Code Availability </span>
                                <input type="text" class="form-control" id="code" name="code" autocomplete="off" maxlength="7" required/>
                                <button class="btn btn-primary"type="submit" id="SearchCodeBtn">
                                    <i class='bx bx-search-alt'></i>
                                     Search
                                </button>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="col-lg-3" style="display: none;" id="code_success">
                <button class="btn btn-primary fw-semibold">
                    <i class='bx bx-check-double'></i> &nbsp; Available
                </button>
            </div>
            <div class="col-lg-3" style="display: none;" id="code_error">
                <button class="btn btn-danger fw-semibold">
                    <i class='bx bx-x'></i> &nbsp; Not Available
                </button>
            </div>
    </div>



{{-- <div class="row mb-4">
        <div class="col-lg-6">
                <div class="d-flex align-items-end">
                    <div class="card shadow-lg bg-white rounded">
                        <div class="input-group">
                            <span class="input-group-text">Code Verify &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                            <input type="text" class="form-control" id="qr" name="qr" autocomplete="off" maxlength="7" required/>
                            <button class="btn btn-primary"type="submit" id="SearchQRCodeBtn">
                                <i class='bx bx-search-alt'></i>
                                &nbsp;&nbsp;Check
                            </button>

                        </div>
                    </div>
                </div>
        </div>
        <div class="col-lg-3" style="display: none;" id="qr_success">
            <button class="btn btn-primary fw-semibold">
                <i class='bx bx-check-double'></i> Invoice No: <p id="invoice"></p>
            </button>
        </div>
        <div class="col-lg-3" style="display: none;" id="qr_error">
            <button class="btn btn-danger fw-semibold">
                <i class='bx bx-x'></i> &nbsp; Not Available
            </button>
        </div>
</div> --}}

    <div class="row">
        <div class="col-lg-4 mb-4 order-0">
            <div class="d-flex align-items-end row">
                <img class="mx-auto" src="{{ asset('front/images/sureX-print.jpg') }}" alt="NodeTech SureX ">
            </div>
        </div>

        <div class="col-lg-4 mb-4 order-0">
            <div class="d-flex align-items-end row">
                <img class="mx-auto" src="{{ asset('front/images/integration2.jpg') }}" alt="NodeTech SureX ">
            </div>
        </div>

        <div class="col-lg-4 mb-4 order-0">
            <div class="d-flex align-items-end row">
                <img class="mx-auto" src="{{ asset('front/images/banner1.jpg') }}" alt="NodeTech SureX ">
            </div>
        </div>

        <div class="col-lg-12 mb-4 order-0">
            <div class="d-flex align-items-end row">
                <img class="mx-auto" src="{{ asset('front/images/sureX solution.png') }}" alt="NodeTech SureX ">
            </div>
        </div>

    </div>

</div>
@endsection


@push('js')
    <script>
        // code check function
        var SearchCodeUrl = "{{ url('search_code') }}";

        $(document).ready(function() {
            $("#SearchCodeBtn").attr("onclick", "SearchCodeFunction()");
        });
        function SearchCodeFunction() {
            console.log('SearchCodeFunction called');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            var postData = {};
            postData["_token"] = $('input[name="_token"]').val();
            postData["code"] = $('input[name="code"]').val();
            $.ajax({
                type: "POST",
                async: true,
                url: SearchCodeUrl,
                data: postData,
                dataType: "JSON",
                success: function(response) {
                    if (response.hasOwnProperty("success")) {
                        console.log('CodeVerify success');

                        $("#code_success").css("display","block");
                        $("#code_error").hide();
                    }
                    if (response.hasOwnProperty("error")) {
                        console.log('CodeVerify error');
                        $("#code_error").css("display","block");
                        $("#code_success").hide();
                        // $("#CodeWrong").hide();
                        // $("#CodeNull").delay(100).fadeIn();
                    }
                }
            });
        }




    /////////////////// QR CODE Verify
        var SearchQRCodeUrl = "{{ url('search_qr_code') }}";
        $(document).ready(function() {
            $("#SearchQRCodeBtn").attr("onclick", "SearchQRCodeFunction()");
        });
        function SearchQRCodeFunction() {
            console.log('SearchQRCodeFunction called');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            var postData = {};
            postData["_token"] = $('input[name="_token"]').val();
            postData["qr"] = $('input[name="qr"]').val();
            $.ajax({
                type: "POST",
                async: true,
                url: SearchQRCodeUrl,
                data: postData,
                dataType: "JSON",
                success: function(response) {
                    console.log(response.exists);
                    if (response.status == 'success') {
                        console.log('CodeVerify success');
                        console.log(response.invoice[invoice]);

                        $("#qr_success").css("display","block");
                        $("#invoice").append(response.invoice[0]);
                        $("#qr_error").hide();
                    }
                    if (response.status == 'error') {
                        console.log('CodeVerify error');
                        $("#qr_error").css("display","block");
                        $("#qr_success").hide();
                        // $("#CodeWrong").hide();
                        // $("#CodeNull").delay(100).fadeIn();
                    }
                }
            });
        }
    </script>
@endpush
