@extends('admin.layouts.layout')
@section('title', 'Depot | SureX Admin Panel')
@section('content')
    {{-- Data Table --}}
    <div class="row">
        <div class="col">
            <div class="card">
                <!-- Create Profile Modal -->
                <h5 class="card-header">
                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal"
                        data-bs-target="#createProfile">
                        Create Dipot <i class='bx bx-plus'></i>
                    </button>
                </h5>

                <div class="card-body p-4">
                    <table id="example" class="table dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                                <th class="col-0">ID</th>
                                <th>Name</th>
                                <th>Address</th>

                                <th>View</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($dipos as $data)
                                <tr>
                                    <td>{{ $data->id }}</td>
                                    <td>{{ $data->dipo_name }}</td>
                                    <td>{{ $data->address }}</td>
                                    <td class="col-2">
                                        <!-- Update User modal -->
                                        <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal"
                                            data-bs-target="#user_update_{{ $data->id }}">
                                            <i class='bx bx-edit'></i>
                                        </button>
                                        <!-- Delete User modal -->
                                        <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                            data-bs-target="#user_delete_{{ $data->id }}">
                                            <i class='bx bx-trash-alt'></i>
                                        </button>
                                    </td>
                                </tr>

                                <!-- Update User modal -->
                                <div class="modal fade" id="user_update_{{ $data->id }}" tabindex="-1"
                                    aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <form action="{{ route('dipo.update', [$data]) }}" method="POST">
                                                @csrf
                                                @method('put')
                                                <div class="modal-header">

                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close">
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row g-2">
                                                        <div class="col mb-3">
                                                            <div class="form-floating">
                                                                <input name="dipo_name" type="text"
                                                                    class="form-control @error('dipo_name') is-invalid @enderror"
                                                                    id="floatingInput" value="{{ $data->dipo_name }}"
                                                                    aria-describedby="floatingInputHelp" />
                                                                <label for="floatingInput">Dipot Name</label>
                                                            </div>
                                                        </div>

                                                    </div>


                                                    <div class="row g-2">
                                                        <div class="col mb-3">
                                                            <div class="form-floating">
                                                                <input name="address" type="text"
                                                                    class="form-control @error('address') is-invalid @enderror"
                                                                    id="floatingInput" value="{{ $data->address }}"
                                                                    aria-describedby="floatingInputHelp" />
                                                                <label for="floatingInput">Address</label>
                                                            </div>
                                                        </div>

                                                    </div>


                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-outline-secondary"
                                                        data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">Save
                                                        changes</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- End  Update User modal -->




                                <!-- Delete User modal -->
                                <div class="modal fade" id="user_delete_{{ $data->id }}" tabindex="-1"
                                    aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <form action="{{ route('user_delete', ['id' => $data->id]) }}" method="POST">
                                                @csrf
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="modalCenterTitle"> <b> Delete Account : </b>
                                                        {{ $data->name }} </h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"> </button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="alert alert-warning">
                                                        <h6 class="alert-heading fw-bold mb-1">Are you sure you want to
                                                            delete your account?</h6>
                                                        <p class="mb-0">Once you delete your account, there is no going
                                                            back. Please be certain.</p>
                                                    </div>
                                                    <button type="submit" class="btn btn-danger deactivate-account">Delete
                                                        Account</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- End  Delete User modal -->
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>



    <!-- Create Profile Modal -->
    <div class="modal fade" id="createProfile" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalCenterTitle">
                        Dipo Form
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    </button>
                </div>
                <div class="card p-4">
                    <form id="formAccountSettings" method="POST" action="{{ route('dipo.store') }} ">
                        @csrf
                        <div class="row">

                            <div class="mb-3 col-md-12">
                                <label for="dipo_name" class="form-label">Name</label>
                                <input class="form-control @error('dipo_name') is-invalid @enderror"
                                    value="{{ old('dipo_name') }}" type="text" id="dipo_name" name="dipo_name"
                                    autofocus required />
                                @error('dipo_name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="mb-3 col-md-12">
                                <label class="form-label" for="phoneNumber">Address</label>
                                <input type="text" id="address" name="address"
                                    class="form-control @error('address') is-invalid @enderror"" required />
                                @error('address')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>



                        </div>
                        <div class="mt-2">
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Create Profile Modal -->


@endsection
