@extends('admin.layouts.layout')

@section('title', 'Depot Panel | SureX Admin Panel')

@section('content')
    <form class="row" action="{{ route('scan-invoice') }}" id="scanFrom" method="POST">
        @csrf
        <div class="row p-2">
            <div class="card col-md-5 p-2">


                <h4>Scan Invoice</h4>


                <div class="col-12">
                    <input class="form-control" id="scanInput" name="invoice_id" placeholder="Scan QR ..." value=""
                        onkeyup="addInvoice()" onchange="addInvoice()" />
                </div>




            </div>



            <div class="card col-md-6 p-2" style="margin-left: 1rem;">

                <h4>Scan Medicine</h4>

                <input class="form-control" name="id" type="hidden" value="{{ @$uploadData[0]->id }}" />
                <div class="col-12">
                    <input class="form-control" id="scanMedicine" placeholder="Scan QR ..." value=""
                        {{-- onkeyup="addMedicine()" --}} onchange="addMedicine()" />
                </div>


                <br />
                <div>
                    <table class="table table-striped table-bordered" id="dataTable" style="width:100%">
                        <thead>
                            <tr>
                                <th class="col-1">Sl</th>
                                <th>Code</th>
                                <th>Delete</th>
                            </tr>
                        </thead>
                        <tbody id="dataTable">


                        </tbody>
                    </table>
                </div>

                <button type="button" onclick="savebutton()">save</button>

            </div>

        </div>
    </form>
    <script>
        $("#scanInput").focus();

        function savebutton() {
            $("#scanFrom").submit();
        }

        function addInvoice() {
            var inputValue = $("#scanInput").val();
            console.log(inputValue.length);
            if (inputValue !== '') {
                if (inputValue.length === 10) {
                    $("#scanMedicine").focus();
                }
                // Append a new row to the table
            }
        }


        function addMedicine() {
            var inputValue = $("#scanMedicine").val();
            console.log(inputValue.length);

            if (inputValue !== '') {
                if (inputValue.length == 10) {

                    if ($("#dataTable tbody tr").length === 0) {
                        $("#scanInput").val(inputValue)
                        $("#scanMedicine").val('').focus();
                        // alert("Medicine list is empty. Please scan medicines before proceeding.");
                        // $("#scanMedicine").focus(); // Set focus to the medicine input
                    } else {
                        $("#scanFrom").submit();
                    }



                } else if (inputValue.length == 7) {
                    // Check if the code already exists in the table
                    var isDuplicate = false;
                    $('#dataTable tbody tr').each(function() {
                        var existingCode = $(this).find('td:eq(1)').text().trim();
                        if (existingCode === inputValue) {
                            isDuplicate = true;
                            return false; // Exit the loop
                        }
                    });

                    if (!isDuplicate) {
                        $('#dataTable tbody').append(
                            '<tr><td>0</td><td>' + inputValue +
                            '<input type="hidden" name="code[]" value="' + inputValue +
                            '"></td><td><a href="#" class="btn btn-sm btn-danger"><i class="bx bx-trash-alt"></i></a></td></tr>'
                        );
                        // Update the row numbers
                        $('#dataTable tbody tr').each(function(index) {
                            $(this).find('td:first').text(index + 1);
                        });
                        $("#scanMedicine").val('').focus();
                    } else {
                        // alert("This code is already in the table.");
                        $("#scanMedicine").val('').focus();
                    }
                }
            }
        }


        // function addMedicine() {
        //     var inputValue = $("#scanMedicine").val();
        //     console.log(inputValue.length);
        //     // return false
        //     if (inputValue !== '') {
        //         if (inputValue.length == 10) {
        //             $("#scanFrom").submit();
        //         }
        //         // if (inputValue.length == 7) {
        //             if (inputValue.length == 7) {
        //             $('#dataTable tbody').append('<tr><td>0</td><td>' + inputValue +
        //                 '<input type="hidden" name="code[]" value="' + inputValue +
        //                 '"></td><td><a href="#" class="btn btn-sm btn-danger"><i class="bx bx-trash-alt"></i></a></td></tr>'
        //             );
        //             // Update the row numbers
        //             $('#dataTable tbody tr').each(function(index) {
        //                 $(this).find('td:first').text(index + 1);
        //             });
        //             $("#scanMedicine").val('').focus();
        //         }
        //         // Append a new row to the tabl
        //     }
        // }
    </script>
@endsection
