<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('qr_code_checks', function (Blueprint $table) {
            $table->id();

            $table->string('phone_number', 16)->nullable();
            $table->string('code', 11)->nullable();
            $table->string('remarks', 32)->nullable();
            $table->string('location')->nullable();
            $table->enum('buy', ['yes','no'])->default('no');
            $table->enum('source', ['web','sms'])->default('web');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('qr_code_checks');
    }
};
