<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
use Illuminate\Support\Facades\File;
use Dompdf\Dompdf;
use Illuminate\Support\Facades\Storage;

class GenerateQRCodesAndPDF implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    protected $start;
    protected $end;
    protected $page;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($start, $end, $page)
    {
        $this->start = $start;
        $this->end = $end;
        $this->page = $page;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $directory = public_path("qrcodes");
        if (!File::isDirectory($directory)) {
            File::makeDirectory($directory, 0777, true, true);
        }
        $directory = public_path("pdfs");
        if (!File::isDirectory($directory)) {
            File::makeDirectory($directory, 0777, true, true);
        }
        //
        $qrCodes = [];

        for ($i = $this->start; $i <= $this->end; $i++) {
            // Generate QR code and save to storage
            $qrCode = QrCode::size(70)->generate("QR Code $i");
            $qrCodePath = public_path("qrcodes/qrcode_$i.png");
            // $qrCode->format('png')->store($qrCodePath);
            file_put_contents($qrCodePath, $qrCode);
            $qrCodes[] = $qrCodePath;
        }

        // Generate PDF for current page
        $pdf = PDF::loadView('pdf.qrcodes', compact('qrCodes'));
        $pdfPath = "public/pdfs/qrcodes_page_$this->page.pdf";
        $pdfPath = storage_path("app/public/pdfs/qrcodes_page_$this->page.pdf");
        $pdf->save($pdfPath);

        // Return the path for downloading
        return $pdfPath;
    }
}
