<?php

namespace App\Http\Controllers;

use App\Models\Code;
use App\Models\Order;
use App\Models\Track;
use App\Models\Template;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use PDF;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Dompdf\Dompdf;
use Dompdf\Options;
use ZipArchive;

class OrderController extends Controller
{

    public function __construct()
    {
        // $this->middleware('auth');
    }


    public function index()
    {
        $codes = DB::table('codes')->select('id')->where('status', 0)->count();
        $templates = Template::orderBy('id', 'desc')->get();
        $orders = Order::orderBy('id', 'desc')->get();
        return view('admin.order')->with([
            'codes' => $codes,
            'templates' => $templates,
            'orders' => $orders,
        ]);
    }



    // public function store(Request $req)
    // {

    //     // dd($req->all());
    //     Track::create([
    //         'user_id' => Auth::user()->id,
    //         'action' => 3 // code generate
    //     ]);

    //     ini_set('memory_limit', '4090M');
    //     ini_set('max_execution_time', 180); //3 mintues
    //     if ($req->quantity <= 400000) {
    //         $filename = $req->datapack_name . '.csv';
    //         $order = Order::create([
    //             'template_id' => $req->template_id,
    //             'manufacture_date' => $req->manufacture_date,
    //             'expiry_date' => $req->expiry_date,
    //             'quantity' => $req->quantity,
    //             'batch_number' => $req->batch_number,
    //             'file' => $filename,
    //         ]);
    //         $collection = DB::table('codes')
    //             ->select('code')
    //             ->where('status', 0)
    //             ->where(DB::raw('CHAR_LENGTH(code)'), '=', 7)
    //             ->where('code', 'not like', '%0%')
    //             ->orderBy('id', 'desc')
    //             ->take($req->quantity);

    //         if ($req->quantity > 500) $chunk = 500;
    //         else $chunk = $req->quantity;

    //         $qrcodes = [];
    //         foreach ($collection->get()->chunk($chunk) as $codes) {
    //             foreach ($codes as $code) {
    //                 $qrcodes[] = QrCode::size(70)->generate($code->code);
    //             }
    //         }
    //         $quantity = $req->quantity;
    //         $collection->update(['status' => $order->id]);
    //         Order::where('id', $order->id)->update(['status' => 'finished']);
    //         return back()->with('success', 'Code Generation Successfull.');
    //         return view('qrcodes', compact('qrcodes', 'quantity'))->with('success', 'Code Generation Successfull.');
    //     } else {
    //         return back()->with('error', 'Code Generation Failed.');
    //     }
    // }


    public function loadMore(Request $request)
    {
        $chunk = $request->input('chunk');
        $offset = $request->input('offset');
        $page = $request->input('page');
        $quantity = $request->input('total');
        // $qrcodes = QrCode::select('code')->skip($offset)->take($chunk)->get();
        if (($quantity / ($page * $offset)) >= 1) {
            $collection = DB::table('codes')
                ->select('code')
                ->where('status', 0)
                ->where(DB::raw('CHAR_LENGTH(code)'), '=', 7)
                ->where('code', 'not like', '%0%')
                ->orderBy('id', 'desc')
                ->skip($offset)
                ->take($chunk);
            $qrcodes = [];
            foreach ($collection->get()->chunk($chunk) as $codes) {
                foreach ($codes as $code) {
                    $qrcodes[] = QrCode::size(70)->generate($code->code);
                }
            }
            return view('qrcodesTwo', compact('qrcodes'));
        }
        return response()->json(['qrcodes' => ""], 400);
    }



    public function store(Request $req)
    {

        // dd($req->all());

        ini_set('memory_limit', '4090M');
        Track::create([
            'user_id' => Auth::user()->id,
            'action' => 3 // code generate
        ]);

        if ($req->quantity <= 400000) {
            // dd($req->all());
            $filename = $req->datapack_name . '.csv';
            $filename1 = $req->datapack_name . '-batch.csv';
            $batch_number = null;
            $batch_sql = null;
            if (isset($req->batch_number_first)) {
                $batch_number = $req->batch_number_first;
                $batch_sql = DB::raw("CONCAT('$batch_number', code)");
            }
            if (isset($req->batch_number_middle)) {
                $batch_number = $req->batch_number_middle;
                $batch_sql = DB::raw("CONCAT(SUBSTRING(code, 1, 4), '$batch_number', SUBSTRING(code, 5,7))");
            }
            if (isset($req->batch_number_last)) {
                $batch_number = $req->batch_number_last;
                $batch_sql = DB::raw("CONCAT(code,  '$batch_number')");
            }

            $order = Order::create([
                'template_id' => $req->template_id,
                'manufacture_date' => $req->manufacture_date,
                'expiry_date' => $req->expiry_date,
                'quantity' => $req->quantity,
                'batch_number' => $batch_number,
                'file' => $filename,
                'batch_file' => $filename1,
            ]);

            $collection = DB::table('codes')
                ->select('code')
                ->where('status', 0)
                ->where(DB::raw('CHAR_LENGTH(code)'), '=', 7)
                ->where('code', 'not like', '%0%')
                ->orderBy('id', 'desc')
                ->take($req->quantity)
                ->update([
                    'batch_number' => $batch_sql
                ]);

            $collection1 = DB::table('codes')
                ->select('code', 'batch_number')
                ->where('status', 0)
                ->where(DB::raw('CHAR_LENGTH(code)'), '=', 7)
                ->where('code', 'not like', '%0%')
                ->orderBy('id', 'desc')
                ->take($req->quantity);
            $collection2 = DB::table('codes')
                ->select('code', 'batch_number')
                ->where('status', 0)
                ->where(DB::raw('CHAR_LENGTH(code)'), '=', 7)
                ->where('code', 'not like', '%0%')
                ->orderBy('id', 'desc')
                ->take($req->quantity);
            // ->get();

            // dd($collection, $collection1);

            $handle = fopen(public_path('Codes/' . $filename), 'w+');

            if ($req->quantity > 500) $chunk = 500;
            else $chunk = $req->quantity;

            foreach ($collection1->get()->chunk($chunk) as $codes) {
                foreach ($codes as $code) {
                    fputcsv($handle, [$code->code]);
                }
            }

            fclose($handle);



            $handle = fopen(public_path('Codes/' . $filename1), 'w+');

            if ($req->quantity > 500) $chunk = 500;
            else $chunk = $req->quantity;

            foreach ($collection2->get()->chunk($chunk) as $codes) {
                foreach ($codes as $code) {
                    fputcsv($handle, [$code->batch_number]);
                }
            }

            fclose($handle);

            $collection1->update(['status' => $order->id]);
      
            Order::where('id', $order->id)->update(['status' => 'finished']);

            return back()->with('success', 'Code Generation Successfull.');
        } else {
            return back()->with('error', 'Code Generation Failed.');
        }
    }


    public function generatePDFsWithQRCodesInBatches()
    {

        // Define the number of items per batch
        $itemsPerBatch = 1000;
        $totalItems = Code::count();
        $totalBatches = ceil($totalItems / $itemsPerBatch);

        // Create a directory to store PDFs temporarily
        $tempDirectory = storage_path('pdfs');
        if (!file_exists($tempDirectory)) {
            mkdir($tempDirectory, 0777, true);
        }

        // Generate PDFs with QR codes for each batch
        for ($batch = 1; $batch <= $totalBatches; $batch++) {
            $offset = ($batch - 1) * $itemsPerBatch;
            $items = Code::skip($offset)->take($itemsPerBatch)->get();

            foreach ($items as $item) {
                $qrCode = QrCode::size(300)->generate($item->code);
                $pdf = PDF::loadView('pdf.qrcodes', compact('qrCode'));
                $pdf->save("{$tempDirectory}/{$item->id}.pdf");
            }
        }

        // Create a zip file containing all PDFs
        $zipFileName = 'qr_codes_all_batches.zip';
        $zip = new ZipArchive();
        $zip->open(storage_path($zipFileName), ZipArchive::CREATE | ZipArchive::OVERWRITE);
        foreach (glob("{$tempDirectory}/*.pdf") as $file) {
            $zip->addFile($file, basename($file));
        }
        $zip->close();

        // Delete temporary PDF files
        foreach (glob("{$tempDirectory}/*.pdf") as $file) {
            unlink($file);
        }

        // Return download response for the zip file
        return response()->download(storage_path($zipFileName))->deleteFileAfterSend();
    }

    public function qrPint($orderid)
    {
        $qrcodeData =  Code::where('status', $orderid)->get();
        $qrcodes = [];


        foreach ($qrcodeData as $item) {
            $qrcodes[] = QrCode::size(70)->generate($item->code);
        }

        return view('qrcodes', compact('qrcodes'))->with('success', 'Code Generation Successfull.');
    }

    public function qrCodePint($orderid)
    {
        $qrcodeData =  Code::where('status', $orderid)->get();
        $qrcodes = [];
        foreach ($qrcodeData as $item) {
            $qrcodes[] = QrCode::size(70)->generate($item->code);
            $codes[] = $item->code;
        }

        return view('qrcodesText', compact('qrcodes', 'codes'))->with('success', 'Code Generation Successfull.');
    }
}






// public function store(Request $req)
// {
//     // dd($req->all());

//     // $order_id = Order::select('id')->orderBy('id', 'desc')->first()->id;
//     // $order_id = $order_id+1;
//     $filename = $req->datapack_name . '_' . $req->file . '.csv';
//     // $req->manufacture_date = $req->manufacture_date . "-28";
//     // $req->expiry_date = $req->expiry_date . "-28";

//     $order = Order::create([
//         'template_id' => $req->template_id,
//         'manufacture_date' => $req->manufacture_date,
//         'expiry_date' => $req->expiry_date,
//         'quantity' => $req->quantity,
//         'batch_number' => $req->batch_number,
//         'file' => $filename,
//     ]);


//     Track::create([
//         'user_id' => Auth::user()->id,
//         'action' => 3 // code generate
//     ]);

//     $collection = Code::select('code')
//         ->where('status', 0)
//         ->where(DB::raw('CHAR_LENGTH(code)'), '=', 7)
//         ->where('code','not like','%0%')
//         ->orderBy('id','desc')
//         ->take($req->quantity);

//     $handle = fopen(public_path('Codes/' . $filename), 'w+');
//     if ($req->quantity > 500) $chunk = 500;
//     else $chunk = $req->quantity;

//     foreach ($collection->get()->chunk($chunk) as $codes) {
//         foreach ($codes as $code) {
//             fputcsv($handle, [
//                 "KUM " . $code->code,
//             ]);
//         }
//     }

//     fclose($handle);
//     $collection->update(['status' => $order->id]);
//     Order::where('id', $order->id)->update(['status' => 'finished']);

//     return back()->with('success','Code Generation Successfull.');
// }








// if ($request->prefix == "qr") {
//     foreach ($collection->get()->chunk($chunk) as $codes) {
//         //echo "1";
//         foreach ($codes as $code) {
//             fputcsv($handle, [
//                 'https://panacea.live/v/' . $code->code,
//                 // 'qrv.io/v/' . $code->code,
//             ]);
//         }
//     }
// }
