<?php

namespace App\Http\Controllers;

use App\Models\Dipo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class DipoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $dipos = Dipo::all();
        return view('admin.dipos')->with('dipos', $dipos);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $dipo = new Dipo();
        $dipo->dipo_name =  $request->dipo_name;
        $dipo->address =  $request->address;
        $dipo->save();

        Session::flash('success', 'Dipo Created Successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Dipo  $dipo
     * @return \Illuminate\Http\Response
     */
    public function show(Dipo $dipo)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Dipo  $dipo
     * @return \Illuminate\Http\Response
     */
    public function edit(Dipo $dipo)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Dipo  $dipo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Dipo $dipo)
    {
        //
        $dipo->dipo_name =  $request->dipo_name;
        $dipo->address =  $request->address;
        $dipo->save();

        Session::flash('success', 'Dipo Created Successfully');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Dipo  $dipo
     * @return \Illuminate\Http\Response
     */
    public function destroy(Dipo $dipo)
    {
        //
    }
}
