<?php

namespace App\Http\Controllers;

use App\Http\Collection\InvoiceCollectionClass;
use App\Models\Code;
use App\Models\CodeHistory;
use Illuminate\Http\Request;
use App\Models\Depot;
use App\Models\ScanMedicine;
use App\Models\UploadInvoice;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Cache;


class DepotController extends Controller
{
    //
    function index()
    {
        $uploadData =  UploadInvoice::where('status', 2)
            ->where('scan_by', auth()->user()->id)
            // ->limit(5)
            ->get();

        if (count($uploadData) == 0) {
            $lastProcessedRecordId = Cache::get('last_processed_record_id_' . auth()->user()->id);
            $uploadData =  UploadInvoice::where('status', 0)
                // ->limit(5)
                ->get();

            foreach ($uploadData as $invoice) {
                $invoice->status = 2;
                $invoice->scan_by = auth()->user()->id;
                $invoice->save();
            }

            if ($uploadData->isNotEmpty()) {
                $lastProcessedRecordId = $uploadData->last()->id;
                Cache::put('last_processed_record_id_' . auth()->user()->id, $lastProcessedRecordId);
            }

            $uploadData =  UploadInvoice::where('status', 2)
                ->where('scan_by', auth()->user()->id)
                // ->limit(5)

                ->get();
        }

        $scanData =  UploadInvoice::where('status', 1)
            ->where('scan_by', auth()->user()->id)
            ->orderBy('id', 'desc')
            // ->limit(5)
            ->get();

        return view('admin.depot', compact('uploadData', 'scanData'));
    }

    function uploadInvoice(Request $request)
    {
        $file = $request->file('excel_file');
        Excel::import(new InvoiceCollectionClass, $file);
        return redirect()->back()->with('success', 'Data imported successfully.');
    }


    function scanInvoice(Request $request)
    {



        //------update code----------
        for ($i = 0; $i < count($request->code); $i++) {

            $invoice = new ScanMedicine();
            $invoice->invoice_id = $request->invoice_id;
            $invoice->code = $request->code[$i];
            $invoice->created_by = auth()->user()->id;
            $invoice->save();
        }


        return redirect()->back()->with('success', 'Data saved successfully.');
    }
    function returnCode(Request $request)
    {


        $invoice =  ScanMedicine::where('code', $request->code)->orderBy('id', 'desc')->first();

        $invoice->return_at = date("Y-m-d h:i:s");
        $invoice->save();
        //------update code----------


        return redirect()->back()->with('success', 'Data saved successfully.');
    }


    public function depotReport()
    {
        return view('admin.depot_report');
    }
    public function searchDepotReport(Request $request)
    {
        $scannedData =  ScanMedicine::with('user')->whereDate('created_at', '>=', $request->from_dt)
            ->whereDate('created_at', '<=', $request->end_dt)->get();
    
        return view('admin.depot_report', compact('scannedData'));
    }
}
