<?php

namespace App\Http\Collection;

use App\Models\UploadInvoice;
use Maatwebsite\Excel\Concerns\ToCollection;
use Illuminate\Support\Collection;

class InvoiceCollectionClass implements ToCollection
{
    public function collection(Collection $rows)
    {
        $rows->shift();
        foreach ($rows as $row) {
            if (!empty(array_filter($row->toArray()))) {
                UploadInvoice::create([
                    'file_name' => time(),
                    'invoice_id' => $row[0],
                ]);
            }
        }
    }
}
